/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* CE2_ECPKI_GenKeyPair function. 
*
* \version CE2_ECPKI_KG.c#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_ECPKI_KG.h"
#include "LLF_ECPKI_KG.h"
#include <memory.h>

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_ECPKI_GenKeyPair
*
* Inputs:
* @param DomainID [in] - The enumerator variable defines the current EC domain;
* @param UserPrivKey_ptr [out] - A pointer to the output private key structure.
* @param UserPublKey_ptr [out] - A pointer to the otput public key structure.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECPKI_GEN_KEY_INVALID_PRIVATE_KEY_PTR_ERROR
*   - CE2_ECPKI_GEN_KEY_INVALID_PUBLIC_KEY_PTR_ERROR
*   - CE2_ECPKI_GEN_KEY_ILLEGAL_DOMAIN_ID_ERROR
*
* \brief \b 
* Description:
*  This function generate new key pair for ECC.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Initialize output structures;
*  -# Call low level function LLF_ECPKI_GenKeyPair 
*     for generation of new key pair with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_ECPKI_GenKeyPair(
	CE2_ECPKI_DomainID_t  	    DomainID,	        /*in*/   
	CE2_ECPKI_UserPrivKey_t   *UserPrivKey_ptr,    /*out*/
	CE2_ECPKI_UserPublKey_t   *UserPublKey_ptr    /*out*/)
{
  if (UserPrivKey_ptr == DX_NULL)
    return CE2_ECPKI_GEN_KEY_INVALID_PRIVATE_KEY_PTR_ERROR;
  if (UserPublKey_ptr == DX_NULL)
    return CE2_ECPKI_GEN_KEY_INVALID_PUBLIC_KEY_PTR_ERROR;

  if ((DomainID <= CE2_ECPKI_DomainID_EMPTY) || 
    (DomainID >= CE2_ECPKI_DomainID_OffMode))
    return CE2_ECPKI_GEN_KEY_ILLEGAL_DOMAIN_ID_ERROR;

  /* Initialize UserPrivKey_ptr structure */
  memset(UserPrivKey_ptr->PrivKeyDbBuff, 0, ECPKI_USER_KEY_MAX_BUFFER_SIZE);
  UserPrivKey_ptr->DomainID = DomainID;
  UserPrivKey_ptr->valid_tag = ECPKI_USER_KEY_MAX_BUFFER_SIZE;

  /* Initialize UserPublKey_ptr structure */
  memset(UserPublKey_ptr->PublKeyDbBuff, 0, ECPKI_USER_KEY_MAX_BUFFER_SIZE);
  UserPublKey_ptr->DomainID = DomainID;
  UserPublKey_ptr->valid_tag = ECPKI_USER_KEY_MAX_BUFFER_SIZE;

  return LLF_ECPKI_GenKeyPair(DomainID, UserPrivKey_ptr, UserPublKey_ptr);
} /* End of CE2_ECPKI_GenKeyPair */
